// PROGRAMME ARDUINO POUR AMBI'SON V3

#include "Arduino.h"
#include "SoftwareSerial.h"
#include "DFRobotDFPlayerMini.h"

const int pinRx = 12;
const int pinTx = 13;
const int pinBouton = 2;
const int pinVolume = A7;
const int pinBusy = 11;

SoftwareSerial mySoftwareSerial(pinRx, pinTx);
DFRobotDFPlayerMini myDFPlayer;

int valActuel = -1;
int volumeActuel = -1;

int etatBouton = 1;
int boutonPrecedent = 1;
int boutonBase = 0;
int boutonTime = 0;

int modeLecture;

int nombreDeFichiers;
int fichier = 0;

int *recentFiles;
int recentFilesIndex = 0;
bool listePleine = false;

void setup() {
  mySoftwareSerial.begin(9600);
  Serial.begin(19200);
  Serial.println("");

  pinMode(pinBouton, INPUT_PULLUP);
  pinMode(pinBusy, INPUT_PULLUP);

  int tentativesConnexion = 1;
  while (!myDFPlayer.begin(mySoftwareSerial)) {
    Serial.print("Pb communication : vérifier SDcard. Tentative n°");
    Serial.println(tentativesConnexion);
    tentativesConnexion++;
    delay(1000);
  }
  delay(500);

  myDFPlayer.setTimeOut(500);

  myDFPlayer.enableDAC();
  myDFPlayer.volume(0);

  nombreDeFichiers = myDFPlayer.readFileCounts();
  Serial.print("Nombre de fichiers : ");
  Serial.println(nombreDeFichiers);

  modeLecture = 'aleatoire';
  Serial.println("MODE initial : Boucle Aléatoire");

  recentFiles = new int[nombreDeFichiers]; // Allouer le tableau des fichiers récents
  for (int i = 0; i < nombreDeFichiers; i++) {
    recentFiles[i] = -1;
  }

  delay(1000);
  volume();

  randomSeed(analogRead(pinVolume));
}

void loop() {
  random(analogRead(pinVolume));
  
  volume();
  bouton();
  lecture();
}

void volume() {
  int val = analogRead(pinVolume);
  int volume = map(val, 0, 1023, 0, 30);

  int seuil = 10 + volumeActuel;
  if (abs(val - valActuel) >= seuil && volume != volumeActuel) {
    delay(50);

    myDFPlayer.volume(volume);
    Serial.print("VOLUME réglé sur : ");
    Serial.print(volume);
    Serial.print(" (");
    Serial.print(val);
    Serial.println(")");

    volumeActuel = volume;
    valActuel = val;

    delay(500);
  }
}

void bouton() {
  etatBouton = digitalRead(pinBouton);

  if (etatBouton == LOW) {
    modeLecture = 'zero';
    boutonBase = millis();
    boutonTime = millis();

    while (etatBouton == LOW) {
      etatBouton = digitalRead(pinBouton);
      boutonTime = millis();
      delay(50);

      if ((boutonTime - boutonBase) < 5000 && modeLecture != 'unique') {
        Serial.println("MODE modifié : 1 fichier aléatoire");
        modeLecture = 'unique';
        aleatoire();
        delay(250);
      } else if ((boutonTime - boutonBase) >= 5000 && modeLecture != 'suite') {
        myDFPlayer.play(1);
        modeLecture = 'suite';
        Serial.println("MODE modifié : Boucle Suite");
        Serial.println("LECTURE du premier fichier");
        delay(250);
      }
    }
    boutonPrecedent = 0;
  } else if (etatBouton == HIGH && boutonPrecedent == 0) {
    boutonPrecedent = 1;
  }
}

void lecture() {
  if (digitalRead(pinBusy) == HIGH) {
    if (modeLecture == 'aleatoire') {
      aleatoire();
      delay(250);
    } else if (modeLecture == 'suite') {
      suite();
      delay(250);
    }
  }
}

void aleatoire() {
  bool fichierDejaLu;
  do {
    fichierDejaLu = false;
    fichier = random(1, nombreDeFichiers + 1);

    for (int i = 0; i < recentFilesIndex; i++) {
      if (fichier == recentFiles[i]) {
        fichierDejaLu = true;
        break;
      }
    }
  } while (fichierDejaLu);
  
  myDFPlayer.play(fichier);
  Serial.print("LECTURE du fichier n°");
  Serial.print(fichier);

  Serial.print(" (fichiers récents : ");
  for (int i = 0; i < recentFilesIndex; i++) {
    Serial.print(recentFiles[i]);
    if (i < recentFilesIndex - 1) {
      Serial.print(", ");
    }
  }
  Serial.println(")");

  recentFiles[recentFilesIndex] = fichier;
  recentFilesIndex++;

  if (recentFilesIndex >= nombreDeFichiers) {
    recentFilesIndex = 0;
    listePleine = true;
    Serial.println("La liste est pleine, réinitialisation.");
  }
}

void suite() {
  myDFPlayer.next();
  Serial.println("LECTURE du fichier suivant");
}
